<?php
/* --------------------------------------------------------------
   TrackingCodeNotFoundException.php 2020-03-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode\Exceptions;

use Exception;

/**
 * Class TrackingCodeNotFoundException
 *
 * @package Gambio\Admin\TrackingCode\Exceptions
 */
class TrackingCodeNotFoundException extends Exception
{
    /**
     * Creates a new TrackingCodeNotFoundException instance for a provided ID.
     *
     * @param int $id
     *
     * @return static
     */
    public static function forId(int $id): self
    {
        return new self('Could no found tracking code with ID "' . $id . '".');
    }
}